﻿#pragma   once

class ATL_NO_VTABLE CArchiveCategoryProvider :
	public CComObjectRootEx<CComSingleThreadModel>,
	public ICategoryProvider
{
public:
  CArchiveCategoryProvider(IShellFolder2 *psf);
  ~CArchiveCategoryProvider();

DECLARE_NOT_AGGREGATABLE(CArchiveCategoryProvider)

BEGIN_COM_MAP(CArchiveCategoryProvider)
  COM_INTERFACE_ENTRY(ICategoryProvider)
END_COM_MAP()

  DECLARE_PROTECT_FINAL_CONSTRUCT()

  HRESULT FinalConstruct()
  {
    return S_OK;
  }

  void FinalRelease()
  {
  }

public:

  // ICategoryProvider
  STDMETHODIMP CanCategorizeOnSCID(__in const SHCOLUMNID *pscid);
  STDMETHODIMP GetDefaultCategory(__out GUID *pguid, __out SHCOLUMNID *pscid);
  STDMETHODIMP GetCategoryForSCID(__in const SHCOLUMNID *pscid, __out GUID *pguid);
  STDMETHODIMP EnumCategories(__out IEnumGUID **penum);
  STDMETHODIMP GetCategoryName(__in const GUID *pguid, __out LPWSTR pszName, __in UINT cch);
  STDMETHODIMP CreateCategory(__in const GUID *pguid, __in REFIID riid, __out void **ppv);

private:

  IShellFolder2 *m_psf;
};

class ATL_NO_VTABLE CArchiveCategoryEnumGUID :
	public CComObjectRootEx<CComSingleThreadModel>,
	public IEnumGUID
{
public:
  CArchiveCategoryEnumGUID();
  ~CArchiveCategoryEnumGUID();

DECLARE_NOT_AGGREGATABLE(CArchiveCategoryEnumGUID)

BEGIN_COM_MAP(CArchiveCategoryEnumGUID)
  COM_INTERFACE_ENTRY(IEnumGUID)
END_COM_MAP()

  DECLARE_PROTECT_FINAL_CONSTRUCT()

  HRESULT FinalConstruct()
  {
    return S_OK;
  }

  void FinalRelease()
  {
  }

public:

  // IEnumGUID
  STDMETHODIMP Next(__in ULONG celt, __out GUID *rgelt, __out ULONG *pceltFetched);
  STDMETHODIMP Skip(__in ULONG celt);
  STDMETHODIMP Reset();
  STDMETHODIMP Clone(__out IEnumGUID **ppenum);

private:
  //ULONG m_ulCurrentIndex;
};

class ATL_NO_VTABLE CArchiveCategorizerName :
	public CComObjectRootEx<CComSingleThreadModel>,
	public ICategorizer
{
public:
  CArchiveCategorizerName(IShellFolder2 *psf);
  ~CArchiveCategorizerName();

DECLARE_NOT_AGGREGATABLE(CArchiveCategorizerName)

BEGIN_COM_MAP(CArchiveCategorizerName)
  COM_INTERFACE_ENTRY(ICategorizer)
END_COM_MAP()

  DECLARE_PROTECT_FINAL_CONSTRUCT()

  HRESULT FinalConstruct()
  {
    return S_OK;
  }

  void FinalRelease()
  {
  }

public:

  // ICategorizer
  STDMETHODIMP GetDescription(__out LPWSTR pszDesc, __in UINT cch);
  STDMETHODIMP GetCategory(__in UINT cidl, __in PCUITEMID_CHILD_ARRAY apidl, __out DWORD *rgCategoryIds);
  STDMETHODIMP GetCategoryInfo(__in DWORD dwCategoryId, __out CATEGORY_INFO *pci);
  STDMETHODIMP CompareCategory(__in CATSORT_FLAGS csfFlags, __in DWORD dwCategoryId1, __in DWORD dwCategoryId2);

private:
  IShellFolder2 *m_psf;
};
